### Parses the content of an error generated by parse
### Romain Francois <francoisromain@free.fr>
parseError <- function (err)
{
	msg <- unlist(strsplit(err, "\\\n"))
	line.nb <- (regexpr("^\\d+", msg) > 0)
	if (any(line.nb)) {
		msg <- msg[1:(min(which(line.nb)) - 1)]
		msg <- paste(msg, collapse = "")
	} else {
		return(structure(data.frame(file = NA_character_, line = NA_integer_,
			column = NA_integer_, message = NA_character_, type = "error"),
			class = c("parseError", "data.frame")))
	}
  
	rx <- "^.*?:\\s*(.*?):(.*?):(.*?): *(.*)$"
	file <- sub(rx, "\\1", msg, perl = TRUE)
	if (file == msg) {
		file <- NA_character_
		rx <- "^(.).*?:(.*?):(.*?): *(.*)$"
	}
	line <- try(as.integer(sub(rx, "\\2", msg, perl = TRUE)), silent = TRUE)
	if (inherits(line, "try-error")) line <- NA_integer_
	column <- try(as.integer(sub(rx, "\\3", msg, perl = TRUE)), silent = TRUE)
	if (inherits(column, "try-error"))
		column <- NA_integer_
	## FIXME: there is a bug here: if we use tabulations, they are converted into
	## four spaces somewhere... That means the column number is not correct any more
	## For now, we prefer to return column 1 everytime until the bug is fixed!
	column <- 1
	message <- sub(rx, "\\4", msg, perl = TRUE)
  
	return(structure(data.frame(file = file, line = line, column = column,
		message = message, type = "error", stringsAsFactors = FALSE),
		class = c("parseError", "data.frame")))
}
