% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_mb.R
\name{mb.boot}
\alias{mb.boot}
\title{Moving block bootstrap for IRFs of identified SVARs}
\usage{
mb.boot(x, b.length = 15, horizon, nboot, nc = 1, dd = NULL,
  itermax = 300, steptol = 200, iter2 = 50)
}
\arguments{
\item{x}{SVAR object of class "svars"}

\item{b.length}{Length of each block}

\item{horizon}{Time horizon of impulse response functions}

\item{nboot}{Number of bootstrap iterations}

\item{nc}{Number of processor cores (Not available on windows machines)}

\item{dd}{Object of class 'indepTestDist'. A simulated independent sample of the same size as the data.  If not supplied, it will be calculated by the function}

\item{itermax}{Maximum number of iterations for DEoptim}

\item{steptol}{Tolerance for steps without improvement for DEoptim}

\item{iter2}{Number of iterations for the second optimization}
}
\description{
Calculating confidence bands for impulse response via moving block bootstrap
}
\examples{
\donttest{
# data contains quarterly observations from 1965Q1 to 2008Q3
# x = output gap
# pi = inflation
# i = interest rates
set.seed(23211)
v1 <- VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.ngml(v1)
summary(x1)

# switching columns according to sign patter
x1$B <- x1$B[,c(3,2,1)]
x1$B[,3] <- x1$B[,3]*(-1)

# impulse response analysis with confidence bands
bb <- mb.boot(x1, b.length = 15, nboot = 100, horizon = 30)
plot(bb, lowerq = 0.05, upperq = 0.95)
}

}
\references{
Brueggemann, R., Jentsch, C., and Trenkler, C. (2016). Inference in VARs with conditional heteroskedasticity of unknown form. Journal of Econometrics 191, 69-85.
}
\seealso{
\code{\link{id.cvm}}, \code{\link{id.dc}}, \code{\link{id.ngml}} or \code{\link{id.cv}}
}
