% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonts.R
\name{font_face}
\alias{font_face}
\title{Create a font-face specification}
\usage{
font_face(
  family,
  woff2 = NULL,
  woff = NULL,
  ttf = NULL,
  otf = NULL,
  eot = NULL,
  svg = NULL,
  local = NULL,
  weight = NULL,
  style = NULL,
  range = NULL,
  variant = NULL,
  stretch = NULL,
  feature_setting = NULL,
  variation_setting = NULL
)
}
\arguments{
\item{family}{The font family name this font should respond to.}

\item{woff2, woff, ttf, otf, eot, svg}{URLs to the font in different formats. At
least one must be given. Best browser support is provided by the woff
format.}

\item{local}{One or more font names that local installations of the font may
have. If a local font is found with either of the given names it will be
used and no download will happen.}

\item{weight}{An optional value for the \code{font-weight} descriptor}

\item{style}{An optional value for the \code{font-style} descriptor}

\item{range}{An optional value for the \code{unicode-range} descriptor Will give
the range of unicode values that this font will support}

\item{variant}{An optional value for the \code{font-variant} descriptor}

\item{stretch}{An optional value for the \code{font-stretch} descriptor}

\item{feature_setting}{An optional value for the \code{font-feature-settings}
descriptor It is recommended to avoid using this if possible}

\item{variation_setting}{An optional value for the \code{font-variation-settings}
descriptor.}
}
\value{
A character string with the \verb{@font-face} block.
}
\description{
Webfonts in SVG and HTML can either be specified manually using the
\verb{@font-face} at-rule, or imported from e.g. Google Fonts using the \verb{@import}
at-rule. \code{font_face()} helps you create a valid \verb{@font-face} block for the
\code{web_fonts} argument in \code{\link[=svglite]{svglite()}} and \code{\link[=svgstring]{svgstring()}} functions.
}
\examples{
font_face(
  family = "MyHelvetica",
  ttf = "MgOpenModernaBold.ttf",
  local = c("Helvetica Neue Bold", "HelveticaNeue-Bold"),
  weight = "bold"
)

}
