% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.epspath.R
\name{predict.epspath}
\alias{predict.epspath}
\title{Make predictions from a "epspath" object}
\usage{
\method{predict}{epspath}(object, newx, svr.eps = 1, ...)
}
\arguments{
\item{object}{The epspath object}

\item{newx}{Values of x to be predicted. This is a matrix with observations per row. Default is x in the epspath object.}

\item{svr.eps}{The value of the "epsilon-insensitive loss" paramter, epsilon.}

\item{...}{Generic compatibility}
}
\value{
In each case, the desired prediction.
}
\description{
Provides a prediction value at a given \code{epsilon} from \code{epspath} object.
}
\examples{
set.seed(1)
n <- 30
p <- 50

x <- matrix(rnorm(n*p), n, p)
e <- rnorm(n, 0, 1)
beta <- c(1, 1, rep(0, p-2))
y <- x \%*\% beta + e
lambda <- 1
obj <- epspath(x, y, lambda = lambda)
predict(obj, svr.eps = .1)

}
\author{
Dohyun Kim, Seung Jun Shin
}
