% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events_N_duration.R
\name{events_n}
\alias{events_n}
\title{Number of Events}
\usage{
events_n(data)
}
\arguments{
\item{data}{A dataframe with a \code{keep} column (representing which rows
are defined as events of collective motion) and a \code{set} column.}
}
\value{
an integer with the number of events of collective motion (sequences
 of \code{keep == TRUE}).
}
\description{
This function calculates the number of events of collective
 motion in a dataset.
}
\examples{

data <- data.frame(
set = c(rep('1', 50), rep('2', 50)),
keep = c(rep(FALSE, 10), rep(TRUE, 70), rep(FALSE, 20))
)

events_n(data) ## 2 events

}
\seealso{
\code{\link{define_events}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
