% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.mnprobit}
\alias{summary.mnprobit}
\title{Summary for an Object of Class mnprobit}
\usage{
\method{summary}{mnprobit}(object, ..., vcov = NULL, show_ind = FALSE)
}
\arguments{
\item{object}{object of class 'mnprobit'}

\item{...}{further arguments (currently ignored)}

\item{vcov}{positively defined numeric matrix representing
asymptotic variance-covariance matrix of the estimator to be
used for calculation of standard errors and p-values. It may also be a 
character. Then \code{\link[switchSelection]{vcov.mnprobit}} function
will be used which input argument \code{type} will be set to \code{vcov}.
If \code{estimator = "2step"} then \code{vcov} should be an estimate of the 
asymptotic covariance matrix of the first step estimator.}

\item{show_ind}{logical; if \code{TRUE} then indexes of parameters will be
shown. Particularly, these indexes may be used in \code{ind} element of
\code{regularization} parameter of \code{\link[switchSelection]{mvoprobit}}.}
}
\value{
Returns an object of class 'summary.mnprobit'.
}
\description{
Provides summary for an object of class 'mnprobit'.
}
\details{
If \code{vcov} is \code{NULL} then this function just changes the 
class of the 'mnprobit' object to 'summary.mnprobit'. Otherwise it 
additionally changes \code{object$cov} to \code{vcov} and use it to
recalculate \code{object$se}, \code{object$p_value} and \code{object$tbl} 
values. It also adds the value of \code{ind} argument to the object.
}
