% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotReference.R
\name{plotReference}
\alias{plotReference}
\title{Function to plot reference, colored by cell type}
\usage{
plotReference(
  reference,
  as.density = TRUE,
  bins = 10,
  bandwidth = 1.5,
  title = "Reference",
  color.by = "cell_type",
  celltype.colors = NULL,
  show.legend = TRUE,
  show.labels = TRUE,
  show.centroids = FALSE
)
}
\arguments{
\item{reference}{Symphony reference object (must have UMAP stored)}

\item{as.density}{if TRUE, plot as density; if FALSE, plot as individual cells}

\item{bins}{for density, nbins parameter for stat_density_2d}

\item{bandwidth}{for density, bandwidth parameter for stat_density_2d}

\item{title}{Plot title}

\item{color.by}{metadata column name for phenotype labels}

\item{celltype.colors}{custom color mapping}

\item{show.legend}{Show cell type legend}

\item{show.labels}{Show cell type labels}

\item{show.centroids}{Plot soft cluster centroid locations}
}
\value{
A ggplot object.
}
\description{
Function to plot reference, colored by cell type
}
