/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import java.util.Arrays;
import sample.SingleNodes;
import vcf.BasicGL;
import vcf.GL;

public class SingleBaumLevel {
    private static final int INITIAL_CAPACITY = 400;
    private static final double MIN_VALUE = 4.94E-322;
    private final Dag dag;
    private final GL gl;
    private int marker = -1;
    private int sample = -1;
    private int size = 0;
    private int capacity = 400;
    private int[] edges1 = new int[400];
    private int[] edges2 = new int[400];
    private double[] fwdValues = new double[400];
    private double[] bwdValues = new double[400];
    private double fwdValueSum = 0.0;
    private double bwdValueSum = 0.0;
    private int nGenotypes = 0;
    private double[] gtProbs = new double[3];

    public SingleBaumLevel(Dag dag, GL gL) {
        if (!dag.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("marker inconsistency");
        }
        this.dag = dag;
        this.gl = gL;
    }

    public static void initializeNodes(SingleNodes singleNodes) {
        singleNodes.clear();
        singleNodes.sumUpdate(0, 0, 1.0);
    }

    public void setForwardValues(SingleNodes singleNodes, int n, int n2) {
        this.marker = n;
        this.sample = n2;
        this.nGenotypes = this.gl.marker(n).nGenotypes();
        this.size = 0;
        this.fwdValueSum = 0.0;
        this.bwdValueSum = 0.0;
        this.initializeGtProbs();
        this.setStates(singleNodes);
        this.setChildNodes(singleNodes);
    }

    private void initializeGtProbs() {
        if (this.gtProbs.length < this.nGenotypes) {
            int n = Math.max(this.nGenotypes, 3 * this.gtProbs.length / 2 + 1);
            this.gtProbs = new double[n];
        } else {
            for (int i = 0; i < this.nGenotypes; ++i) {
                this.gtProbs[i] = 0.0;
            }
        }
    }

    private void setStates(SingleNodes singleNodes) {
        int n;
        double d = 0.0;
        int n2 = singleNodes.size();
        for (n = 0; n < n2; ++n) {
            int n3 = singleNodes.enumNode1(n);
            int n4 = singleNodes.enumNode2(n);
            int n5 = this.dag.nOutEdges(this.marker, n3);
            for (int i = 0; i < n5; ++i) {
                int n6 = this.dag.outEdge(this.marker, n3, i);
                byte by = this.dag.symbol(this.marker, n6);
                int n7 = this.dag.nOutEdges(this.marker, n4);
                for (int j = 0; j < n7; ++j) {
                    int n8 = this.dag.outEdge(this.marker, n4, j);
                    byte by2 = this.dag.symbol(this.marker, n8);
                    float f = this.gl.gl(this.marker, this.sample, by, by2);
                    if (!((double)f > 0.0)) continue;
                    if (this.size == this.capacity) {
                        this.ensureCapacity(this.size + 1);
                    }
                    this.edges1[this.size] = n6;
                    this.edges2[this.size] = n8;
                    double d2 = this.dag.condEdgeProb(this.marker, n6);
                    double d3 = this.dag.condEdgeProb(this.marker, n8);
                    double d4 = (double)f * singleNodes.enumValue(n) * (d2 * d3);
                    if (d4 < 4.94E-322 && singleNodes.enumValue(n) > 0.0) {
                        d4 = 4.94E-322;
                    }
                    this.fwdValues[this.size++] = d4;
                    d += d4;
                }
            }
        }
        assert (d > 0.0 ^ this.size == 0);
        n = 0;
        while (n < this.size) {
            int n9 = n++;
            this.fwdValues[n9] = this.fwdValues[n9] / d;
        }
        this.fwdValueSum = d;
    }

    public void setChildNodes(SingleNodes singleNodes) {
        singleNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edges1[i]);
            int n2 = this.dag.childNode(this.marker, this.edges2[i]);
            singleNodes.sumUpdate(n, n2, this.fwdValues[i]);
        }
    }

    public void setInitialBackwardValues(SingleNodes singleNodes) {
        singleNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edges1[i]);
            int n2 = this.dag.childNode(this.marker, this.edges2[i]);
            singleNodes.maxUpdate(n, n2, 1.0);
        }
        this.setBackwardValues(singleNodes);
    }

    public void setBackwardValues(SingleNodes singleNodes) {
        int n;
        int n2;
        int n3;
        this.bwdValueSum = 0.0;
        double d = 0.0;
        for (n3 = 0; n3 < this.size; ++n3) {
            double d2;
            n2 = this.dag.childNode(this.marker, this.edges1[n3]);
            n = this.dag.childNode(this.marker, this.edges2[n3]);
            this.bwdValues[n3] = d2 = singleNodes.value(n2, n);
            this.bwdValueSum += d2;
        }
        singleNodes.clear();
        for (n3 = 0; n3 < this.size; ++n3) {
            int n4;
            int n5 = n3;
            this.bwdValues[n5] = this.bwdValues[n5] / this.bwdValueSum;
            n2 = this.edges1[n3];
            n = this.edges2[n3];
            byte by = this.symbol1(n3);
            byte by2 = this.symbol2(n3);
            int n6 = this.dag.parentNode(this.marker, n2);
            int n7 = this.dag.parentNode(this.marker, n);
            double d3 = this.dag.condEdgeProb(this.marker, n2);
            double d4 = this.dag.condEdgeProb(this.marker, n);
            double d5 = this.fwdValues[n3] * this.bwdValues[n3];
            int n8 = n4 = BasicGL.genotype(by, by2);
            this.gtProbs[n8] = this.gtProbs[n8] + d5;
            d += d5;
            double d6 = this.gl.gl(this.marker, this.sample, by, by2);
            double d7 = this.bwdValues[n3] * (d3 * d4) * d6;
            if (d7 < 4.94E-322 && this.bwdValues[n3] > 0.0) {
                d7 = 4.94E-322;
            }
            singleNodes.sumUpdate(n6, n7, d7);
        }
        n3 = 0;
        while (n3 < this.nGenotypes) {
            int n9 = n3++;
            this.gtProbs[n9] = this.gtProbs[n9] / d;
        }
    }

    public Dag dag() {
        return this.dag;
    }

    public GL gl() {
        return this.gl;
    }

    public int marker() {
        return this.marker;
    }

    public int nGenotypes() {
        return this.nGenotypes;
    }

    public double gtProbs(int n) {
        if (n >= this.nGenotypes) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return this.gtProbs[n];
    }

    public int size() {
        return this.size;
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(this.size));
        }
    }

    public int edge1(int n) {
        this.checkIndex(n);
        return this.edges1[n];
    }

    public int edge2(int n) {
        this.checkIndex(n);
        return this.edges2[n];
    }

    public int parentNode1(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edges1[n]);
    }

    public int parentNode2(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edges2[n]);
    }

    public int childNode1(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edges1[n]);
    }

    public int childNode2(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edges2[n]);
    }

    public byte symbol1(int n) {
        return this.dag.symbol(this.marker, this.edge1(n));
    }

    public byte symbol2(int n) {
        return this.dag.symbol(this.marker, this.edge2(n));
    }

    public double forwardValue(int n) {
        this.checkIndex(n);
        return this.fwdValues[n];
    }

    public double backwardValue(int n) {
        this.checkIndex(n);
        return this.bwdValues[n];
    }

    public double forwardValuesSum() {
        return this.fwdValueSum;
    }

    public double backwardValuesSum() {
        return this.bwdValueSum;
    }

    public String toString() {
        String string = " ";
        String string2 = " | ";
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("level=");
        stringBuilder.append(this.marker);
        stringBuilder.append(" size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" forwardValuesSum=");
        stringBuilder.append(this.fwdValueSum);
        stringBuilder.append(" backwardSum=");
        stringBuilder.append(this.bwdValueSum);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("j=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.edge1(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edge2(i));
            stringBuilder.append(string);
            stringBuilder.append(this.forwardValue(i));
            stringBuilder.append(string);
            stringBuilder.append(this.backwardValue(i));
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            this.capacity = this.capacity * 3 / 2 + 1;
            if (this.capacity < n) {
                this.capacity = n;
            }
            this.edges1 = Arrays.copyOf(this.edges1, this.capacity);
            this.edges2 = Arrays.copyOf(this.edges2, this.capacity);
            this.fwdValues = Arrays.copyOf(this.fwdValues, this.capacity);
            this.bwdValues = Arrays.copyOf(this.bwdValues, this.capacity);
        }
    }
}

