/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Filter;
import blbutil.SampleFileIterator;
import java.io.File;
import java.util.NoSuchElementException;
import vcf.Marker;
import vcf.VcfRecord;

public final class FilteredVcfIterator
implements SampleFileIterator<VcfRecord> {
    private final SampleFileIterator<VcfRecord> it;
    private final Filter<Marker> filter;
    private VcfRecord next;

    public FilteredVcfIterator(SampleFileIterator<VcfRecord> sampleFileIterator, Filter<Marker> filter) {
        if (sampleFileIterator == null) {
            throw new IllegalArgumentException("it==null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter==null");
        }
        this.it = sampleFileIterator;
        this.filter = filter;
        this.next = FilteredVcfIterator.readNextRecord(sampleFileIterator, filter);
    }

    @Override
    public File file() {
        return this.it.file();
    }

    @Override
    public Samples samples() {
        return this.it.samples();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public VcfRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        VcfRecord vcfRecord = this.next;
        this.next = FilteredVcfIterator.readNextRecord(this.it, this.filter);
        return vcfRecord;
    }

    private static VcfRecord readNextRecord(SampleFileIterator<VcfRecord> sampleFileIterator, Filter<Marker> filter) {
        VcfRecord vcfRecord = null;
        while (vcfRecord == null && sampleFileIterator.hasNext()) {
            VcfRecord vcfRecord2 = (VcfRecord)sampleFileIterator.next();
            if (!filter.accept(vcfRecord2.marker())) continue;
            vcfRecord = vcfRecord2;
        }
        return vcfRecord;
    }

    @Override
    public void remove() {
        String string = "FilteredVcfIterator.remove()";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public void close() {
        this.it.close();
    }
}

