\name{synlik-class}
\alias{synlik}
\alias{synlik-class}
\title{\code{synlik-class}}
\usage{
  synlik(...)
}
\arguments{
  \item{...}{See section "Slots".}
}
\description{
  Basic class for simulation-based approximate inference
  using Synthetic Likelihood methods.  }

  \section{Slots}{ \describe{ \item{param}{Named vector of
  parameters used by \code{object@simulator}
  (\code{numeric}).} \item{simulator}{Function that
  simulates from the model (\code{function}). It has to
  have prototype \code{fun(param, nsim, extraArgs, ...)}.
  If \code{summaries()} is not specified the
  \code{simulator()} has output a matrix with \code{nsim}
  rows, where each row is a vector of simulated statistics.
  Otherwise it can output any kind of object, and this
  output will be passed to \code{summaries()}.}
  \item{summaries}{Function that transforms simulated data
  into summary statistics (\code{function}).  It has to
  have prototype \code{fun(x, extraArgs, ...)} and it has
  to output a matrix with \code{nsim} rows, where each row
  is a vector of simulated statistics. Parameter \code{x}
  contains the data.} \item{data}{Object containing the
  observed data or statistics (\code{ANY}).}
  \item{extraArgs}{List containing all the extra arguments
  to be passed to \code{object@simulator} and
  \code{object@summaries} (\code{list}).}
  \item{plotFun}{Function that will be used to plot
  \code{object@data}. Prototype should be \code{fun(x,
  ...)} (\code{function}).} }
}
\examples{
#### Create Object
ricker_sl <- synlik(simulator = rickerSimul,
                    summaries = rickerStats,
                    param = c( logR = 3.8, logSigma = log(0.3), logPhi = log(10) ),
                    extraArgs = list("nObs" = 50, "nBurn" = 50),
                    plotFun = function(input, ...)
                                plot(drop(input), type = 'l', ylab = "Pop", xlab = "Time", ...)
)

# Simulate from the object
ricker_sl@data <- simulate(ricker_sl)
ricker_sl@extraArgs$obsData <- ricker_sl@data # Needed by WOOD2010 statistics

plot(ricker_sl)
}
\author{
  Matteo Fasiolo <matteo.fasiolo@gmail.com>
}
\references{
  Simon N Wood. Statistical inference for noisy nonlinear
  ecological dynamic systems. Nature, 466(7310):1102--1104,
  2010.
}

