% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generic_functions.R, R/continue_smcmc.R
\docType{methods}
\name{continue}
\alias{continue}
\alias{continue,smcmc-method}
\title{Continuing estimation.}
\usage{
continue(object, ...)

\S4method{continue}{smcmc}(object, niter = object@niter, nsim = object@nsim,
  propCov = object@propCov, targetRate = object@targetRate,
  recompute = object@recompute, multicore = object@multicore,
  ncores = object@ncores, cluster = NULL, control = object@control, ...)
}
\arguments{
\item{object}{An object representing the results of an estimation procedure which we wish to continue.
For example it might represents an MCMC chain.}

\item{...}{additional arguments to be passed to \code{slik} function, see \code{\link{slik}}.}

\item{niter}{see \code{\link{smcmc-class}}.}

\item{nsim}{see \code{\link{smcmc-class}}.}

\item{propCov}{see \code{\link{smcmc-class}}.}

\item{targetRate}{see \code{\link{smcmc-class}}.}

\item{recompute}{see \code{\link{smcmc-class}}.}

\item{multicore}{see \code{\link{smcmc-class}}.}

\item{ncores}{see \code{\link{smcmc-class}}.}

\item{cluster}{an object of class \code{c("SOCKcluster", "cluster")}. This allowes the user to pass her own cluster,
which will be used if \code{multicore == TRUE}. The user has to remember to stop the cluster.}

\item{control}{see \code{\link{smcmc-class}}.}
}
\value{
An object of the same class as \code{object}, where the results of the estimation have been updated.
}
\description{
Generic function, that given the results of an estimation procedure (ex. MCMC or maximum likelihood optimization)
continues the procedure for some more iterations.
}
\details{
When \code{is("smcmc", object) == TRUE}  continues MCMC estimation of an object of class \code{smcmc}. All input parameters are defaulted to the corresponding
slots in the input object, with the exception of cluster. The chain restarts were it ended, burn-in is set to zero, the
same prior (if any) is used.
}
\seealso{
For examples, see \code{\link{smcmc-class}}.
}

