% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_Chaotic.R
\name{data.gen.Rossler}
\alias{data.gen.Rossler}
\title{Rössler system}
\usage{
data.gen.Rossler(
  a = 0.2,
  b = 0.2,
  w = 5.7,
  start = c(-2, -10, 0.2),
  time = seq(0, by = 0.05, length.out = 1000),
  s
)
}
\arguments{
\item{a}{The \emph{a} parameter. Default: 0.2.}

\item{b}{The \emph{b} parameter. Default: 0.2.}

\item{w}{The \emph{w} parameter. Default: 5.7.}

\item{start}{A 3-dimensional numeric vector indicating the starting point for the time series.
Default: c(-2, -10, 0.2).}

\item{time}{The temporal interval at which the system will be generated.
Default: time=seq(0,50,by=0.01) or time = seq(0,by=0.01,length.out = 1000)}

\item{s}{The level of noise, default 0.}
}
\value{
A list with four vectors named \emph{time}, \emph{x}, \emph{y}
and \emph{z} containing the time, the x-components, the
y-components and the z-components of the Rössler system, respectively.
}
\description{
Generates a 3-dimensional time series using the Rossler equations.
}
\details{
The Rössler system is a system of ordinary differential equations defined as:
\deqn{\dot{x} = -(y + z)}{dx/dt = -(y + z)}
\deqn{\dot{y} = x+a \cdot y}{dy/dt = x + a*y}
\deqn{\dot{z} = b + z*(x-w)}{dz/dt = b + z*(x-w)}
The default selection for the system parameters (\emph{a} = 0.2, \emph{b} = 0.2, \emph{w} = 5.7) is known to
produce a deterministic chaotic time series. However, the values a = 0.1, b = 0.1, and c = 14 are more commonly used.
These Rössler equations are simpler than those Lorenz used since only one nonlinear term appears (the product xz in the third equation).

Here, a = b = 0.1 and c changes. The bifurcation diagram reveals that low values of c are periodic,
but quickly become chaotic as c increases. This pattern repeats itself as c increases ---
there are sections of periodicity interspersed with periods of chaos,
and the trend is towards higher-period orbits as c increases.
For example, the period one orbit only appears for values of c around 4
and is never found again in the bifurcation diagram. The same phenomenon is seen with period three;
until c = 12, period three orbits can be found, but thereafter, they do not appear.
}
\note{
Some initial values may lead to an unstable system that will tend to infinity.
}
\examples{
###synthetic example - Rössler

ts.r <- data.gen.Rossler(a = 0.1, b = 0.1, w = 8.7, start = c(-2, -10, 0.2),
                         time = seq(0, by=0.05, length.out = 10000))

oldpar <- par(no.readonly = TRUE)
par(mfrow=c(1,1), ps=12, cex.lab=1.5)
plot.ts(cbind(ts.r$x,ts.r$y,ts.r$z), col=c("black","red","blue"))

par(mfrow=c(1,2), ps=12, cex.lab=1.5)
plot(ts.r$x,ts.r$y, xlab="x",ylab = "y", type = "l")
plot(ts.r$x,ts.r$z, xlab="x",ylab = "z", type = "l")
par(oldpar)
}
\references{
Rössler, O. E. 1976. An equation for continuous chaos. Physics Letters A, 57, 397-398.

Constantino A. Garcia (2019). nonlinearTseries: Nonlinear Time Series Analysis. R package version 0.2.7. https://CRAN.R-project.org/package=nonlinearTseries

wikipedia https://en.wikipedia.org/wiki/R%C3%B6ssler_attractor
}
