% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_font.R
\name{register_variant}
\alias{register_variant}
\title{Register a font as a variant as an existing one}
\usage{
register_variant(
  name,
  family,
  weight = NULL,
  width = NULL,
  features = font_feature()
)
}
\arguments{
\item{name}{The new family name the variant should respond to}

\item{family}{The name of an existing font family that this is a variant of}

\item{weight}{One or two of \code{"thin"}, \code{"ultralight"}, \code{"light"}, \code{"normal"},
\code{"medium"}, \code{"semibold"}, \code{"bold"}, \code{"ultrabold"}, or \code{"heavy"}. If one is
given it sets the weight for the whole variant. If two is given the first
one defines the plain weight and the second the bold weight. If \code{NULL} then
the variants of the given family closest to \code{"normal"} and \code{"bold"} will be
chosen.}

\item{width}{One of \code{"ultracondensed"}, \code{"extracondensed"}, \code{"condensed"},
\code{"semicondensed"}, \code{"normal"}, \code{"semiexpanded"}, \code{"expanded"},
\code{"extraexpanded"}, or \code{"ultraexpanded"} giving the width of the variant. If
\code{NULL} then the width closest to \code{"normal"} will be chosen.}

\item{features}{A \code{\link{font_feature}} object describing the specific OpenType
font features to turn on for the registered font variant.}
}
\description{
This function is a wrapper around \code{\link[=register_font]{register_font()}} that allows you to easily
create variants of existing system fonts, e.g. to target different weights
and/or widths, or for attaching OpenType features to a font.
}
\examples{
# Get the default "sans" family
sans <- match_font("sans")$path
sans <- system_fonts()$family[system_fonts()$path == sans][1]

# Register a variant of it:
register_variant(
  "sans_ligature", 
  sans, 
  features = font_feature(ligatures = "discretionary")
)

registry_fonts()

# clean up
clear_registry()
}
