% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/syuzhet.R
\name{get_transformed_values}
\alias{get_transformed_values}
\title{Fourier Transform and Reverse Transform Values}
\usage{
get_transformed_values(raw_values, low_pass_size = 3, x_reverse_len = 100,
  scale_vals = FALSE, scale_range = FALSE)
}
\arguments{
\item{raw_values}{the raw sentiment values
calculated for each sentence}

\item{low_pass_size}{The number of components
to retain in the low pass filtering. Default = 3}

\item{x_reverse_len}{the number of values to return. Default = 100}

\item{scale_vals}{Logical determines whether or not to normalize the values using the scale function  Default = FALSE.  If TRUE, values will be scaled by subtracting the means and scaled by dividing by their standard deviations.  See ?scale}

\item{scale_range}{Logical determines whether or not to scale the values from -1 to +1.  Default = FALSE.  If set to TRUE, the lowest value in the vector will be set to -1 and the highest values set to +1 and all the values scaled accordingly in between.}
}
\value{
The transformed values
}
\description{
Converts input values into a standardized
 set of filtered and reverse transformed values for
 easy plotting and/or comparison.
}
\examples{
s_v <- get_sentences("I begin this story with a neutral statement.
 Now I add a statement about how much I despise cats.
 I am allergic to them. Basically this is a very silly test.")
 raw_values <- get_sentiment(s_v, method = "bing")
 get_transformed_values(raw_values)
}

