% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.related.R
\name{trakt.shows.related}
\alias{trakt.shows.related}
\title{Search for related shows}
\usage{
trakt.shows.related(target, extended = "min")
}
\arguments{
\item{target}{The \code{id} of the movie requested. Either the \code{slug}
(e.g. \code{"tron-legacy-2010"}), \code{trakt id} or \code{IMDb id}. If multiple \code{target}s are
provided, the results will be \code{rbind}ed together and a \code{source} column as appended,
containing the provided \code{id} of the input.}

\item{extended}{Whether extended info should be provided.
Defaults to \code{"min"}, can either be \code{"min"} or \code{"full"}.}
}
\value{
A \code{data.frame} containing search results
}
\description{
\code{trakt.shows.related} returns shows related to the input show.
}
\details{
Receive a set of shows that are related to a specific show.
}
\note{
See \href{http://docs.trakt.apiary.io/#reference/shows/related/get-related-shows}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
related <- trakt.shows.related("game-of-thrones")
}
}
\seealso{
Other aggregated data: \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.related}};
  \code{\link{trakt.movies.trending}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.trending}}

Other show data: \code{\link{trakt.get_all_episodes}};
  \code{\link{trakt.get_full_showdata}};
  \code{\link{trakt.seasons.season}};
  \code{\link{trakt.seasons.summary}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.ratings}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.show.watching}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.trending}};
  \code{\link{trakt.stats}}
}

