% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagsOneBaseline.R
\name{jagsOneBaseline}
\alias{jagsOneBaseline}
\title{Defines a jags Bayesian model to fit a single baseline trophic position model}
\usage{
jagsOneBaseline(muB = NULL, sigmaB = NULL, muDeltaN = NULL,
  sigmaDeltaN = NULL, sigma = NULL, TP = NULL, lambda = NULL, ...)
}
\arguments{
\item{muB}{a distribution defining prior for mean (mu) of baseline. By
default is dnorm(0, 0.0001).}

\item{sigmaB}{a distribution defining sigma (standard deviation) of baseline.
By default is dunif(0, 100).}

\item{muDeltaN}{a distribution defining prior for the mean (mu) of deltaN.
deltaN stands for trophic discrimination factor of Nitrogen. By default is
dnorm(0, 0.0001).}

\item{sigmaDeltaN}{a distribution defining sigma (standard deviation) of
deltaN. By default is dunif(0, 100).}

\item{sigma}{a value defining sigma (standard deviation) of baseline. By
default is dunif(0, 100).}

\item{TP}{a distribution defining prior of trophic position. By default is
dunif(lambda, 10), with lambda = 2 if no defined before.}

\item{lambda}{an integer indicating the trophic level of the baseline.
Default is 2.}

\item{...}{additional arguments passed to jagsOneBaseline.}
}
\value{
A jags model (BUGS-language) as a character string
}
\description{
This function takes some parameters and returns a jags model object as a
character string for passing to \code{\link[rjags]{jags.model}}.
}
\details{
The single baseline trophic position model is defined as:

\deqn{dNc = dNb + deltaN * (TP - lambda)}

where dNc are d15N values of consumer, dNb1 are d15N values of baseline,
deltaN is the trophic discrimination factor for N, TP is trophic position of
the consumer and lamba is the trophic level of baseline. Furthermore, as a
Bayesian approach, dNb, deltaN and dNc are defined as random parameters with
a normal distribution with mean mu_i and precision tau_i, TP is a random
parameter with a uniform distribution and lambda is a constant. All these
distributions can be changed modifying them as priors, while defining lambda
within the call to the function.

Although it is possible to use a number of predefined or customized
distributions (see distribution aliases in
\href{https://sourceforge.net/projects/mcmc-jags/files/Manuals/}{JAGS
documentation}), it is likely that most of the time you will be using a
normal distribution as prior for most parameters. This is the default option
(i.e. when the function is called without arguments). To change it, you need
to indicate a mean and standard deviation for the parameter of interest, for
example "dnorm(0, 0.0001)". Here, a prior of normally distributed mu is
defined, with a mean 0, and a standard deviation of 0.0001. This constitutes
a normally distributed prior, although uninformative. You might want to
change the mean and/or the standard deviation according to your prior
knowledge of the system/consumer you are working on. As well as the priors
for mu, JAGS uses "tau", which is the precision for defining the standard
deviation of mu. Precision is a deterministic function (instead of the
distributional "~"), and it is calculated as "tau <- power(sigma, -2)", thus
you could define as well sigma_i, which stands for the standard deviation of
the parameter of interest.
}
