% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TDF.R
\name{TDF}
\alias{TDF}
\title{Trophic discrimination factors from bibliography}
\usage{
TDF(author = "Post", element = "both", type = NULL, seed = 3)
}
\arguments{
\item{author}{could be either "Post" or "McCutchan" at the moment.}

\item{element}{can be "both", "N" or "C"}

\item{type}{this argument only works for "McCutchan" author (their Table 3).
"all" returns all TDF data; "whole" and "muscle" returns TDF separated per
type analysis; "acidified" and "unacidified" returns TDF separated per
acidification; and "Rainbow Trout" and "Brook Trout" returns TDF separated
per fish species (according to their Table 1).}

\item{seed}{integer to have replicated results}
}
\value{
a list (if element = "both") or a vector (if element ="N" or element
  = "C") containing TDF values
}
\description{
This function returns trophic discrimination factors (TDF), given an author,
element and a type. For convenience 'type' includes a number of categories
depending on the author. At the moment it includes TDF data from Post (2002)
and from McCutchan et al (2003).
}
\examples{
TDF(author = "McCutchan", element = "N")

}
