% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTOlr.R
\name{tTOlr}
\alias{tTOlr}
\title{Maximum Likelihood Under H1, Given P-value.}
\usage{
tTOlr(
  t = NULL,
  df = NULL,
  nsamp = NULL,
  pval = NULL,
  delta = NULL,
  sd = 1,
  twoSided = TRUE,
  showMax = TRUE
)
}
\arguments{
\item{t}{\code{t}-statistic.  If \code{NULL}, this is calculated from
the \code{p}-value.}

\item{df}{Degrees of freedom.}

\item{nsamp}{Sample size.}

\item{pval}{\code{p}-value.  If \code{NULL}, this is calculated
from the \code{t}-statistic and degrees of freedom.}

\item{delta}{If not \code{NULL}, this specifies the $t$-statistic
for the difference from H0 that is of interest, allowing the
calculation of the corresponding likelihood and likelihood ratio.}

\item{sd}{Standard deviation.}

\item{twoSided}{Set either to \code{TRUE} for a two-sided test,
or \code{FALSE} for a one-sided test.}

\item{showMax}{Set to \code{TRUE} if the maximum of the likelihood
and the likelihood ratio is required.}
}
\value{
List, with elements
 \itemize{
 \item t - \code{t}-statistic
 \item df - Degrees of freedom
 \item pval - P-value
 \item lik0 - Likelihood under H0
 \item likDelta - Likelihood, given difference delta under H0
 \item lrDelta - Likelihood ratio, given difference delta under H0
 \item maxlik - Maximum likelihood, under allowed alternatives H1
 \item lrmax - Maximum of likelihood ratio,
 under allowed alternatives H1
 \item tmax - \code{t}-statistic for difference in means
 that makes likelihood under H1 a maximum
 }
}
\description{
Given the \code{t}-statistic for a difference in means,
or for a mean difference, and degrees of freedom,
determine the maximum likelihood under the alternative
H1, and the $t$-statistic for the difference in means
that makes the likelihood under H1 a maximum.
Additionally, return the likelihood under H0.
}
\examples{
likStats <- tTOlr(pval=0.02, nsamp=c(9,9), twoSided=TRUE,
                delta=1.4, sd=1.2)
print(unlist(likStats),digits=2)
likStats <- tTOlr(t=2.58, df=16, nsamp=c(9,9), twoSided=TRUE,
                  delta=1.4, sd=1.2)
print(unlist(likStats),digits=2)
likStats <- tTOlr(pval=0.02, nsamp=9, twoSided=FALSE,
                delta=1.4, sd=1.2)
print(unlist(likStats),digits=2)
likStats <- tTOlr(t=2.45, df=8, nsamp=9, twoSided=FALSE,
                  delta=1.4, sd=1.2)
print(unlist(likStats),digits=2)

}
