% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tablet.R
\name{as_kable.tablet}
\alias{as_kable.tablet}
\title{Coerce Tablet to Kable}
\usage{
\method{as_kable}{tablet}(
  x,
  ...,
  booktabs = TRUE,
  escape = FALSE,
  escape_latex = tablet::escape_latex,
  escape_html = function(x, ...) x,
  variable = " ",
  col.names = NA,
  linebreak = TRUE,
  align = "c",
  double_escape = FALSE,
  linebreaker = "\\n",
  pack_rows = list(escape = escape),
  secondary = FALSE
)
}
\arguments{
\item{x}{\code{\link{tablet}}}

\item{...}{passed to \code{\link[kableExtra]{kbl}}}

\item{booktabs}{passed to \code{\link[kableExtra]{kbl}}}

\item{escape}{passed to \code{\link[kableExtra]{kbl}}; defaults FALSE to allow header linebreaks}

\item{escape_latex}{a function to pre-process column names and content if 'escape' is FALSE (e.g., manual escaping, latex only); default \code{\link{escape_latex}}}

\item{escape_html}{a function to pre-process column names and content if 'escape' is FALSE (e.g., manual escaping, html only)}

\item{variable}{a column name for the variables}

\item{col.names}{passed to \code{\link[kableExtra]{kbl}} after any linebreaking}

\item{linebreak}{whether to invoke \code{\link[kableExtra]{linebreak}} for column names}

\item{align}{passed to \code{\link[kableExtra]{linebreak}} for column names}

\item{double_escape}{passed to \code{\link[kableExtra]{linebreak}} for column names}

\item{linebreaker}{passed to \code{\link[kableExtra]{linebreak}} for column names in latex; for html, linebreaker is replaced with <br/>}

\item{pack_rows}{named list passed to \code{\link[kableExtra]{pack_rows}} for finer control of variable names}

\item{secondary}{passed to escape_latex}
}
\value{
like \code{\link[kableExtra]{kbl}}
}
\description{
Renders a tablet.  Calls \code{\link[kableExtra]{kbl}} and implements
special features like grouped columns.
}
\details{
See also \code{\link{tablet.data.frame}}.
Column \code{_tablet_name} must inherit 'character' and
by default (in a latex render context) its values
will eventually be processed by \code{escape_latex}.
Thus, if \code{_tablet_name} is of class 'latex'
it will be handled by method \code{\link{escape_latex.latex}}
(which tries not to re-escape metacharacters).
}
\examples{
library(boot)
library(dplyr)
library(magrittr)
library(haven)
library(yamlet)
library(spork)
melanoma \%>\%
  select(-time, -year) \%>\%
  mutate(sex = factor(sex), ulcer = factor(ulcer)) \%>\%
  group_by(status) \%>\%
  tablet \%>\%
  as_kable

x <- system.file(package = 'tablet', 'shiny-examples/mesa/data/adsl.sas7bdat')
x \%<>\% read_sas \%>\% data.frame
decorations(x) 

# calculate BMI by assuming all males are 1.75 m, all females 1.63 cm
x \%<>\% mutate(height = ifelse(sex == 'F', 1.63, 1.75))
x \%<>\% mutate(bmi = signif(digits = 3, weight / (height^2)))
x \%<>\% filter(saffl == 'Y')
x \%<>\% select(trt01a, age, sex, weight, bmi)
x \%<>\% redecorate('
trt01a: [ Treatment, [ Placebo, TRT 10 mg, TRT 20 mg ]]
age:    [ Age, year ]
sex:    [ Sex, [ Female: F, Male: M ]]
weight: [ Body Weight, kg ]
bmi:    [ Index_body mass, kg/m^2 ]
')
x \%<>\% resolve
x \%<>\% group_by(trt01a)

x \%>\% tablet \%>\% as_kable

# supply default and unit-conditional latex titles
x \%<>\% modify(title = concatenate(as_latex(as_spork(c(.data$label)))))
x \%<>\% modify(
age, weight, bmi,
  title = concatenate(
    sep = '',  # default ok in pdf
    as_latex(
      as_spork(
        c(.data$label, ' (', .data$units, ')')
      )
    )
  )
)
x \%>\% tablet \%>\% as_kable
}
