% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phrase.R
\name{phrase}
\alias{phrase}
\alias{p}
\title{Create a musical phrase}
\usage{
phrase(notes, info = NULL, string = NULL, bar = FALSE)

p(notes, info = NULL, string = NULL, bar = FALSE)
}
\arguments{
\item{notes, info}{noteworthy and note info strings. When \code{info = NULL},
it is assumed that \code{notes} refers to a music object or string formatted
as such.}

\item{string}{space-delimited character string or vector (or integer vector
if simple string numbers). This is an optional argument that specifies which
instrument strings to play for each specific timestep. Otherwise \code{NULL}.}

\item{bar}{logical, insert a bar check at the end of the phrase.}
}
\value{
a phrase.
}
\description{
Create a musical phrase from character strings that define notes, note
metadata, and optionally explicit strings fretted. The latter can be used to
ensure proper tablature layout.
}
\details{
A phrase object combines a valid string of notes with a corresponding valid
string of note info. The only required note info is time, but other
information can be included as well. You do not need to input an existing
\code{noteworthy} class object and \code{noteinfo} class object, but both
inputs must be valid and thus coercible to these classes. This is similar to
how the \code{music} class works. The difference with phrase objects is that
they are used to create LilyPond syntax analogous to what a music object
contains.

Note that if you convert a music object to a phrase object, you are changing
contexts. The phrase object is the simplest LilyPond-format music structure.
Coercion with \code{phrase} strips all attributes of a music object and
retains only notes, note info and string numbers.

See the help documentation on \code{noteworthy}, \code{noteinfo}, and
\code{music} classes for an understanding of the input data structures.
The function \code{p} is a convenient shorthand wrapper for \code{phrase}.
}
\examples{
phrase("c ec'g' ec'g'", "4- 4 2") # no string arg (not recommended for tabs)
phrase("c ec4g4 ec4g4", "4 4 2") # same as above
phrase("c b, c", "4. 8( 8)", "5 5 5") # direction implies hammer on
phrase("b2 c d", "4( 4)- 2", "5 5 5") # hammer and slide

phrase("c ec'g' ec'g'", "1 1 1", "5 432 432")
p("c ec'g' ec'g'", 1, "5 4 4") # same as above


n <- "a, b, c d e f g e f g a~ a"
i <- "8- 8 8 8-. t8( t8)( t8) t16( t16)( t16) 8 1"
m <- as_music(n, i)

x <- p(n, i)
x
identical(x, p(m))

x <- "a,4;5*5 b,4- c4 cgc'e'~4 cgc'e'1 e'4;2 c';3 g;4 c;5 ce'1;51"
p(x)
identical(p(x), p(as_music(x)))
}
\seealso{
\code{\link{valid-notes}}, \code{\link{valid-noteinfo}},
\code{\link{music}}
}
