% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setObsVar.R
\name{setObsVar}
\alias{setObsVar}
\title{Set an observed variable}
\usage{
setObsVar(
  schema = NULL,
  name = NULL,
  columns = NULL,
  top = NULL,
  relative = FALSE,
  distinct = FALSE,
  unit = NULL,
  factor = 1,
  key = NULL,
  value = NULL
)
}
\arguments{
\item{schema}{[\code{schema(1)}]\cr In case this information is added to an
already existing schema, provide that schema here (overwrites previous
information).}

\item{name}{[\code{character(1)}]\cr Name of the new measured variable.}

\item{columns}{[\code{integerish(.)}]\cr The column(s) in which the
\emph{values} of the new variable are recorded.}

\item{top}{[\code{integerish(.)}]\cr In case the variable is nested in a wide
identifying variable, specify here additionally the topmost row in which
the variable \emph{name} sits}

\item{relative}{[\code{logical(1)}]\cr whether or not the values provided in
\code{columns} and \code{rows} are relative to the cluster position(s) or
whether they refer to the overall table.}

\item{distinct}{[\code{logical(1)}]\cr Whether or not the variable is
distinct from a cluster. This is the case when the variable is recorded
somewhere 'on the side' and thus not explicitly included in all clusters.}

\item{unit}{[\code{character(1)}]\cr the unit of this variable.}

\item{factor}{[\code{numeric(1)}]\cr the factor that needs to be multiplied
with the values to convert to \code{unit}, defaults to 1. For instance, if
values are recorded in acres, but shall be recorded in hectare, the factor
would be 0.40468.}

\item{key}{[\code{integerish(1)}]\cr If the variable is recorded (together
with other variables) so that the variable names are listed in one column
and the respective values are listed in another column, give here the
number of the column that contains the variable names. Can alternatively be
"cluster", in case observed variables are the cluster ID.}

\item{value}{[\code{character(1)}]\cr If the variable is recorded (together
with other variables) so that the variable names are listed in one column
and the respective values are listed in another column, give here the level
in the names column that refer to the values of this variable.}
}
\value{
An object of class \code{\link{schema}}.
}
\description{
Observed variables are those variables that contain the (quantitative)
observed/measured values of each unique unit (as described by the
\code{\link[=setIDVar]{identifying variables}}). There may be several of them
and in a tidy table they'd be recorded as separate columns.
}
\details{
Please also take a look at the currently suggested strategy to set
  up a \link[=schema]{schema description}.
}
\examples{
# please check the vignette for examples
}
\seealso{
Other functions to describe table arrangement: 
\code{\link{setCluster}()},
\code{\link{setFilter}()},
\code{\link{setFormat}()},
\code{\link{setIDVar}()}
}
\concept{functions to describe table arrangement}
