% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_diversity.R
\docType{methods}
\name{bootstrap_diversity}
\alias{bootstrap_diversity}
\alias{bootstrap,DiversityIndex-method}
\title{Bootstrap Estimation}
\usage{
\S4method{bootstrap}{DiversityIndex}(object, n = 1000, f = NULL)
}
\arguments{
\item{object}{An \R object (typically a \linkS4class{DiversityIndex} object).}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the result of
\code{do}) as argument.}
}
\value{
If \code{f} is \code{NULL} (the default), \code{bootstrap()} returns a named \code{numeric}
vector with the following elements:
\describe{
\item{\code{original}}{The observed value of \code{do} applied to \code{object}.}
\item{\code{mean}}{The bootstrap estimate of mean of \code{do}.}
\item{\code{bias}}{The bootstrap estimate of bias of \code{do}.}
\item{\code{error}}{he bootstrap estimate of standard error of \code{do}.}
}

If \code{f} is a \code{function}, \code{bootstrap()} returns the result of \code{f} applied to
the \code{n} values of \code{do}.
}
\description{
Samples randomly from the elements of \code{object} with replacement.
}
\examples{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Shannon diversity index
(h <- heterogeneity(cantabria, method = "shannon"))

## Bootstrap resampling
bootstrap(h, f = NULL)

bootstrap(h, f = summary)

quant <- function(x) quantile(x, probs = c(0.25, 0.50))
bootstrap(h, f = quant)

## Jackknife resampling
jackknife(h)

bootstrap(h, f = summary)
}
\seealso{
Other resampling methods: 
\code{\link{jackknife_diversity}},
\code{\link{resample}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
