% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity.R
\docType{methods}
\name{richness}
\alias{richness}
\alias{richness-method}
\alias{composition}
\alias{composition-method}
\alias{richness,matrix-method}
\alias{richness,data.frame-method}
\alias{composition,matrix-method}
\alias{composition,data.frame-method}
\title{Richness}
\usage{
richness(object, ...)

composition(object, ...)

\S4method{richness}{matrix}(object, ..., method = c("observed", "margalef", "menhinick"))

\S4method{richness}{data.frame}(object, ..., method = c("observed", "margalef", "menhinick"))

\S4method{composition}{matrix}(object, ..., method = c("chao1", "ace", "squares", "chao2", "ice"))

\S4method{composition}{data.frame}(object, ..., method = c("chao1", "ace", "squares", "chao2", "ice"))
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Further arguments to be passed to internal methods (see below).}

\item{method}{A \code{\link{character}} string or vector of strings specifying the
index to be computed (see details). Any unambiguous substring can be given.}
}
\value{
\itemize{
\item \code{richness()} returns a \linkS4class{RichnessIndex} object.
\item \code{composition()} returns a \linkS4class{CompositionIndex} object.
}
}
\description{
\itemize{
\item \code{richness()} computes sample richness.
\item \code{composition()} computes asymptotic species richness.
}
}
\section{Details}{

The number of observed taxa, provides an instantly comprehensible
expression of diversity. While the number of taxa within a sample
is easy to ascertain, as a term, it makes little sense: some taxa
may not have been seen, or there may not be a fixed number of taxa
(e.g. in an open system; Peet 1974). As an alternative, \emph{richness}
(\eqn{S}) can be used for the concept of taxa number (McIntosh 1967).

It is not always possible to ensure that all sample sizes are equal
and the number of different taxa increases with sample size and
sampling effort (Magurran 1988). Then, \emph{\link[=rarefaction]{rarefaction}}
(\eqn{E(S)}) is the number of taxa expected if all samples were of a
standard size (i.e. taxa per fixed number of individuals).
Rarefaction assumes that imbalances between taxa are due to sampling and
not to differences in actual abundances.
}

\section{Richness Measures}{

The following richness measures are available for count data:
\describe{
\item{\code{observed}}{Number of observed taxa/types.}
\item{\code{margalef}}{\link[=index_margalef]{Margalef richness index}.}
\item{\code{menhinick}}{\link[=index_menhinick]{Menhinick richness index}.}
}
}

\section{Asymptotic Species Richness}{

The following measures are available for count data:
\describe{
\item{\code{ace}}{\link[=index_ace]{Abundance-based Coverage Estimator}.}
\item{\code{chao1}}{(improved/unbiased) \link[=index_chao1]{Chao1 estimator}.}
\item{\code{squares}}{\link[=index_squares]{Squares estimator}.}
}

The following measures are available for replicated incidence data:
\describe{
\item{\code{ice}}{\link[=index_ice]{Incidence-based Coverage Estimator}.}
\item{\code{chao2}}{(improved/unbiased) \link[=index_chao2]{Chao2 estimator}.}
}
}

\examples{
## Data from Magurran 1988, p. 128-129
trap <- matrix(data = c(9, 3, 0, 4, 2, 1, 1, 0, 1, 0, 1, 1,
                        1, 0, 1, 0, 0, 0, 1, 2, 0, 5, 3, 0),
               nrow = 2, byrow = TRUE, dimnames = list(c("A", "B"), NULL))

## Margalef and Menhinick index
richness(trap, method = "margalef") # 2.55 1.88
richness(trap, method = "menhinick") # 1.95 1.66

## Data from Chao & Chiu 2016
brazil <- matrix(
  data = rep(x = c(1:21, 23, 25, 27, 28, 30, 32, 34:37, 41,
                   45, 46, 49, 52, 89, 110, 123, 140),
             times = c(113, 50, 39, 29, 15, 11, 13, 5, 6, 6, 3, 4,
                       3, 5, 2, 5, 2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1,
                       0, 0, 2, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0)),
  nrow = 1, byrow = TRUE
)

## Chao1-type estimators (asymptotic species richness)
composition(brazil, method = c("chao1"), unbiased = FALSE) # 461.625
composition(brazil, method = c("ace"), k = 10) # 445.822
}
\references{
Kintigh, K. W. (1989). Sample Size, Significance, and Measures of
Diversity. In Leonard, R. D. and Jones, G. T., \emph{Quantifying Diversity
in Archaeology}. New Directions in Archaeology. Cambridge:
Cambridge University Press, p. 25-36.

Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press. \doi{10.1007/978-94-015-7358-0}.

Magurran, A E. & Brian J. McGill (2011). \emph{Biological Diversity:
Frontiers in Measurement and Assessment}. Oxford: Oxford University Press.

McIntosh, R. P. (1967). An Index of Diversity and the Relation of Certain
Concepts to Diversity. \emph{Ecology}, 48(3), 392-404. \doi{10.2307/1932674}.

Peet, R. K. (1974). The Measurement of Species Diversity. \emph{Annual Review of
Ecology and Systematics}, 5(1), 285-307.
\doi{10.1146/annurev.es.05.110174.001441}.
}
\seealso{
\code{\link[=index_margalef]{index_margalef()}}, \code{\link[=index_menhinick]{index_menhinick()}}, \code{\link[=index_ace]{index_ace()}},
\code{\link[=index_chao1]{index_chao1()}}, \code{\link[=index_squares]{index_squares()}}, \code{\link[=index_ice]{index_ice()}}, \code{\link[=index_chao2]{index_chao2()}}

\code{\link[=plot.DiversityIndex]{plot()}}

Other diversity measures: 
\code{\link{diversity}()},
\code{\link{evenness}()},
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot.DiversityIndex}()},
\code{\link{plot.RarefactionIndex}()},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{she}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
