% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_chisq.R
\name{tadaa_chisq}
\alias{tadaa_chisq}
\title{Tadaa, Chi-Square Test!}
\usage{
tadaa_chisq(data, x, y, correct = TRUE, print = c("df", "console",
  "html", "markdown"))
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{x}{A vector of categorial data (\code{factor} or \code{character}).}

\item{y}{Another vector of categorial data (also \code{factor} or \code{character}).}

\item{correct}{Apply Yate's continuity correction for 2x2 tables,
passed to \link[stats:chisq.test]{stats::chisq.test}. Defaults to \code{TRUE}.}

\item{print}{Print method, default \code{df}: A regular \code{data.frame}.
Otherwise passed to \link[pixiedust:sprinkle_print_method]{pixiedust::sprinkle_print_method} for fancyness.}
}
\value{
A \code{data.frame} by default, otherwise \code{dust} object,
depending on \code{print}.
}
\description{
A comfortable wrapper of \link[stats:chisq.test]{stats::chisq.test} with pretty output and
effect sizes depending on the size of the contingency table:
Phi coefficient and Odds Ratios in case of a 2x2 table, Cramer's V otherwise.
The result is either returned as a \link[broom:tidy]{broom::tidy} \code{data.frame} or prettified using
various \link[pixiedust:sprinkle]{pixiedust::sprinkle} shenanigans.
}
\note{
The warning message in case of low samples size and possibly incorrect
approximation is suppressed silently.
}
\examples{
tadaa_chisq(ngo, abschalt, geschl)

tadaa_chisq(ngo, abschalt, jahrgang)
}
\seealso{
Other Tadaa-functions: \code{\link{tadaa_aov}},
  \code{\link{tadaa_kruskal}}, \code{\link{tadaa_levene}},
  \code{\link{tadaa_nom}}, \code{\link{tadaa_normtest}},
  \code{\link{tadaa_one_sample}}, \code{\link{tadaa_ord}},
  \code{\link{tadaa_pairwise_gh}},
  \code{\link{tadaa_pairwise_tukey}},
  \code{\link{tadaa_pairwise_t}},
  \code{\link{tadaa_t.test}}, \code{\link{tadaa_wilcoxon}}
}
\concept{Tadaa-functions}
