% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_line3.R
\name{col_line3}
\alias{col_line3}
\title{Plot coloured line(s) in 3 dimensions with plot_ly}
\usage{
col_line3(x, y, z = 0, c, ...)
}
\arguments{
\item{x}{name of object or variable containing data for x axis}

\item{y}{name of object or variable containing data for y axis}

\item{z}{name of object or variable containing data for z axis}

\item{c}{name of object or variable by which to color}

\item{...}{Additional inputs for plot_ly()}
}
\value{
a plot_ly() graphics object
}
\description{
This function is used to plot three dimensional lines with segments colored. It may be just as simple to use plotly::plot_ly() directly.
}
\note{
x, y, z and c must all be the same size vectors. The color axis will by default span the range of values in c, i.e., caxis will be c(min(min(c)), max(max(c))).
}
\examples{
col_line3(1:20, 1:20, 1:20, 1:20)
}
\seealso{
\code{\link{col_line}}, \code{\link{cline}}
}
