% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KISS.R
\name{Kiss}
\alias{Kiss}
\title{Title Kissinger}
\usage{
Kiss(mat)
}
\arguments{
\item{mat}{matrix of the all the thermograms checked using the functiom mat.check}
}
\value{
models "mod", datable "xy" for plot, "Ea" list of value, datatable "DT" built with the values of mat according to the specified degrees
}
\description{
performs analysis of the thermograms using Kissinger method to calculate the activation energy (Ea)
}
\examples{
\donttest{
require(data.table)
require(MASS)
rates=c(0.5,1,2,5,10,20,50)
a<-lapply(rates, function(x) JMA(A=exp(35),Ea=120000,T0=0,T.end=300,q=x,npoints=5000,n=2))
a<-lapply(seq(1,length(a)), function(x) data.table(a[[x]]$time.s,a[[x]]$T.C,
a[[x]]$dadT, rates[[x]]))
lapply(seq(1,length(a)), function(x) setnames(a[[x]],
c("time.seconds","temperature.s","heat.flow","rates") ) )
ar<-testMat(a)
kiss<-Kiss(ar)
}
}
\references{
1. Avrami M. Kinetics of Phase Change. I General Theory. J Chem Phys. 1939;7(12):1103-1112. doi:10.1063/1.1750380.
2. Kissinger HE. Reaction Kinetics in Differential Thermal Analysis. Anal Chem. 1957;29(11):1702-1706. doi:10.1021/ac60131a045.
}
