% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_medication_frequency}
\alias{plot_medication_frequency}
\alias{plot_medication_frequency.medic}
\alias{plot_medication_frequency.summary.medic}
\alias{plot_medication_frequency.medication_frequency}
\title{Plot Medication Frequency}
\usage{
plot_medication_frequency(object, ...)

\method{plot_medication_frequency}{medic}(object, ...)

\method{plot_medication_frequency}{summary.medic}(object, ...)

\method{plot_medication_frequency}{medication_frequency}(
  object,
  scale = "percent",
  scope = "cluster",
  with_population = FALSE,
  ...
)
}
\arguments{
\item{object}{The object containing the medication frequency data.}

\item{...}{Additional arguments passed to the plotting functions.}

\item{scale}{The scale of the y-axis. Must be either "percent" or "count".}

\item{scope}{The scope of the plot. Must be one of "cluster", "global" or
"medication".}

\item{with_population}{Logical value indicating whether to include the
population cluster.}
}
\value{
A ggplot object.
}
\description{
This function plots the medication frequency.
}
\examples{
clust <- medic(complications, id = id, atc = atc, k = 3)

clust |> plot_medication_frequency()
clust |> medication_frequency() |> plot_medication_frequency()
clust |> summary() |> plot_medication_frequency()

}
\seealso{
\code{\link{medication_frequency}}

\code{\link{plot_cluster_frequency}}

\code{\link{plot_comedication_count}}

\code{\link{plot_timing_trajectory}}

\code{\link{plot_timing_atc_group}}

\code{\link{plot_summary}}
}
