% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html5.R
\name{html5.cell_table}
\alias{html5.cell_table}
\title{Convert an abstract table object into an HTML5 string}
\usage{
\method{html5}{cell_table}(object, caption = NA, css = NA,
  fragment = TRUE, inline = NA, id = NA, footnote = NA, ...)
}
\arguments{
\item{object}{The cell table to render to HTML5}

\item{caption}{A string caption for the table}

\item{css}{A string that is the href to the css for complete HTML5}

\item{fragment}{A boolean flag that determines whether a fragment or a complete HTML5 document is generatedf}

\item{inline}{A string containing a filename to include as inline CSS. It first searches the drive for the file, if that fails it looks inside the package for a matching css file.}

\item{id}{A unique identifier for the table (strongly recommended).}

\item{footnote}{Any footnotes to include under the table.}

\item{...}{additional arguments to renderer. Unused}
}
\value{
A text string rendering of the given table
}
\description{
Given a cell_table class, a series of conversion creates an HTML5
representation of the table. It may be an HTML5 fragment or it may
be a complete web page.
}
\details{
The package includes several css files for styling. At present the following exist: 'hmisc.css', 'lancet.css', 'lancet-stripped.css' and 'nejm.css'
}
