% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-lancet.R
\name{lancet_mean_sd}
\alias{lancet_mean_sd}
\title{Create a mean/sd cell object of the given data in Lancet style}
\usage{
lancet_mean_sd(
  x,
  format = NA,
  na.rm = TRUE,
  names = FALSE,
  type = 8,
  msd = FALSE,
  quant = c(0.25, 0.5, 0.75),
  ...
)
}
\arguments{
\item{x}{numeric vector whose sample quantiles are wanted. NA and NaN values are not allowed in numeric vectors unless na.rm is TRUE.}

\item{format}{numeric or character; Significant digits or fmt to pass to sprintf}

\item{na.rm}{logical; if true, any NA and NaN's are removed from x before the quantiles are computed.}

\item{names}{logical; ignored. For compatibility with hmisc_iqr}

\item{type}{integer; ignored. For compatibility with hmisc_iqr}

\item{msd}{logical; ignored. For compatibility with hmisc_iqr}

\item{quant}{numeric; ignored. For compatibility with hmisc_iqr}

\item{...}{additional arguments to constructing cell}
}
\value{
A cell object.
}
\description{
Create a mean/sd cell object of the given data in Lancet style.
}
\examples{
require(stats)
lancet_mean_sd(rnorm(100), '3')
}
