% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_make_future.R
\name{tar_make_future}
\alias{tar_make_future}
\title{Run a pipeline of targets in parallel with transient
\code{future} workers.}
\usage{
tar_make_future(
  names = NULL,
  reporter = "verbose",
  workers = 1L,
  callr_function = callr::r,
  callr_arguments = list()
)
}
\arguments{
\item{names}{Names of the targets to build or check. Set to \code{NULL} to
check/build all the targets (default). Otherwise, you can supply
symbols, a character vector, or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{reporter}{Character of length 1, name of the reporter to user.
Controls how messages are printed as targets run in the pipeline. Choices:
\itemize{
\item \code{"verbose"}: print one message for each target that runs (default).
\item \code{"silent"}: print nothing.
\item \code{"timestamp"}: print a time-stamped message for each target that runs.
\item \code{"summary"}: print a running total of the number of each targets in
each status category (queued, running, skipped, build, cancelled,
or errored).
}}

\item{workers}{Positive integer, maximum number of transient
\code{future} workers allowed to run at any given time.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}
}
\value{
\code{NULL} except if \code{callr_function = callr::r_bg()}, in which case
a handle to the \code{callr} background process is returned. Either way,
the value is invisibly returned.
}
\description{
This function is like \code{\link[=tar_make]{tar_make()}} except that targets
run in parallel with transient \code{future} workers. It requires
that you declare your \code{future::plan()} inside the \verb{_targets.R} script.
\code{future} is not a strict dependency of \code{targets},
so you must install \code{future} yourself.
}
\details{
To configure \code{tar_make_future()} with a computing cluster,
see the \code{future.batchtools} package documentation.
}
\examples{
if (identical(Sys.getenv("TARGETS_LONG_EXAMPLES"), "true")) {
tar_dir({ # Write all files to a temporary directory.
tar_script({
  future::plan(future::multisession)
  tar_option_set()
  list(tar_target(x, 1 + 1))
})
tar_make_future()
})
}
}
