% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_config_set.R
\name{tar_config_set}
\alias{tar_config_set}
\title{Set configuration settings.}
\usage{
tar_config_set(
  inherits = NULL,
  reporter_make = NULL,
  reporter_outdated = NULL,
  store = NULL,
  shortcut = NULL,
  script = NULL,
  workers = NULL,
  config = Sys.getenv("TAR_CONFIG", "_targets.yaml"),
  project = Sys.getenv("TAR_PROJECT", "main")
)
}
\arguments{
\item{inherits}{Character of length 1, name of the project from which
the current project should inherit configuration settings.
The current project is the \code{project} argument, which
defaults to \code{Sys.getenv("TAR_PROJECT", "main")}.
If the \code{inherits} argument \code{NULL}, the \code{inherits} setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{reporter_make}{Character of length 1, \code{reporter} argument to
\code{\link[=tar_make]{tar_make()}} and related functions that run the pipeline.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{reporter_outdated}{Character of length 1, \code{reporter} argument to
\code{\link[=tar_outdated]{tar_outdated()}} and related functions that do not run the pipeline.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{store}{Character of length 1, path to the data store of the pipeline.
If \code{NULL}, the \code{store} setting is left unchanged in the
YAML configuration file (default: \verb{_targets.yaml}).
Usually, the data store lives at \verb{_targets}.
Set \code{store} to a custom directory
to specify a path other than \verb{_targets/}. The path need not exist
before the pipeline begins, and it need not end with "_targets",
but it must be writeable.
For optimal performance, choose a storage location
with fast read/write access.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{shortcut}{logical of length 1, default \code{shortcut} argument
to \code{\link[=tar_make]{tar_make()}} and related functions.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{script}{Character of length 1, path to the target script file
that defines the pipeline (\verb{_targets.R} by default).
This path should be either
an absolute path or a path relative to the project root where you will
call \code{\link[=tar_make]{tar_make()}} and other functions. When \code{\link[=tar_make]{tar_make()}} and friends
run the script from the current working directory.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{workers}{Positive numeric of length 1, \code{workers} argument of
\code{\link[=tar_make_clustermq]{tar_make_clustermq()}} and related functions that run the pipeline
with parallel computing among targets.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{config}{Character of length 1, file path of the YAML
configuration file with \code{targets} project settings.
The \code{config} argument specifies which YAML configuration
file that \code{tar_config_get()} reads from or \code{tar_config_set()}
writes to in a single function call.
It does not globally change which configuration file is used
in subsequent function calls. The default file path of the YAML
file is always \verb{_targets.yaml} unless you set another
default path using the \code{TAR_CONFIG} environment variable,
e.g. \code{Sys.setenv(TAR_CONFIG = "custom.yaml")}. This also has the
effect of temporarily modifying the default arguments to other functions
such as \code{\link[=tar_make]{tar_make()}} because the default arguments
to those functions are controlled by \code{tar_config_get()}.}

\item{project}{Character of length 1, name of the current
\code{targets} project. Thanks to the \code{config} R package,
\code{targets} YAML configuration files can store multiple
sets of configuration settings, with each set corresponding
to its own project. The \code{project} argument allows you to
set or get a configuration setting for a specific project
for a given call to \code{tar_config_set()} or \code{tar_config_get()}.
The default project is always called \code{"main"}
unless you set another
default project using the \code{TAR_PROJECT} environment variable,
e.g. \code{Sys.setenv(tar_project = "custom")}. This also has the
effect of temporarily modifying the default arguments to other functions
such as \code{\link[=tar_make]{tar_make()}} because the default arguments
to those functions are controlled by \code{tar_config_get()}.}
}
\value{
\code{NULL} (invisibly)
}
\description{
\code{tar_config_set()} writes special custom settings
for the current project to an optional YAML configuration file.
}
\section{Configuration}{

For several key functions like \code{\link[=tar_make]{tar_make()}}, the
default values of arguments are controlled though
\code{tar_config_get()}. \code{tar_config_get()} retrieves data
from an optional YAML configuration file.
You can control the settings in the YAML
file programmatically with \code{tar_config_set()}.
The default file path of this YAML file is \verb{_targets.yaml}, and you can
set another path globally using the \code{TAR_CONFIG}
environment variable. The YAML file can store configuration
settings for multiple projects, and you can globally
set the default project with the \code{TAR_PROJECT} environment
variable.
The structure of the YAML file
follows rules similar to the \code{config} R package, e.g.
projects can inherit settings from one another using the \code{inherits} field.
Exceptions include:
\enumerate{
\item There is no requirement to have a configuration named \code{"default"}.
\item Other projects do not inherit from the default project` automatically.
\item Not all fields need values because \code{targets} already has defaults.
}

\code{targets} does not actually invoke
the \code{config} package. The implementation in \code{targets}
was written from scratch without viewing or copying any
part of the source code of \code{config}.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(list(tar_target(x, 1 + 1)))
tar_config_get("store") # NULL (data store defaults to "_targets/")
store_path <- tempfile()
tar_config_set(store = store_path)
tar_config_get("store") # Shows a temp file.
tar_make() # Writes to the custom data store identified in _targets.yaml.
tar_read(x) # tar_read() knows about _targets.yaml too.
file.exists("_targets") # FALSE
file.exists(store_path) # TRUE
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_config_unset}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()},
\code{\link{tar_option_set}()}
}
\concept{configuration}
