% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{leaves}
\alias{leaves}
\title{Get leaf taxa}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object containing taxon
information to be queried.}

\item{subset}{(\code{character}) Taxon IDs for which leaf taxa will be
returned. Default: All taxon in \code{obj} will be used.}

\item{value}{What data to return. This is usually the name of column in a
table in \code{obj$data}. Any result of \code{all_names(obj)} can be used, but it
usually only makes sense to data that corresponds to taxa 1:1, such as
\code{\link[=taxon_ranks]{taxon_ranks()}}. By default, taxon indexes are returned.}
}
\value{
\code{character}
}
\description{
Return the leaf taxa for a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object. Leaf taxa are taxa
with no subtaxa.
\preformatted{
obj$leaves(subset = NULL, value = NULL)
leaves(obj, subset = NULL, value = NULL)}
}
\examples{
# Return indexes of leaf taxa
leaves(ex_taxmap)

# Return indexes for a subset of taxa
leaves(ex_taxmap, subset = 2:17)

# Return something besides taxon indexes
leaves(ex_taxmap, value = "taxon_names")

}
\seealso{
Other taxonomy indexing functions: \code{\link{roots}},
  \code{\link{stems}}, \code{\link{subtaxa}},
  \code{\link{supertaxa}}
}
