% Generated by roxygen2 (4.0.0): do not edit by hand
\name{ncbi_search}
\alias{ncbi_search}
\title{Search for gene sequences available for a species from NCBI.}
\usage{
ncbi_search(taxa, seqrange = "1:3000", getrelated = FALSE, limit = 500,
  verbose = TRUE)
}
\arguments{
\item{taxa}{Scientific name to search for (character).}

\item{seqrange}{Sequence range, as e.g., "1:1000" (character).}

\item{getrelated}{Logical, if TRUE, gets the longest sequences of a species
in the same genus as the one searched for. If FALSE, get's nothing.}

\item{limit}{Number of sequences to search for and return. Max of 10,000.
If you search for 6000 records, and only 5000 are found, you will of course
only get 5000 back.}

\item{verbose}{logical; If TRUE (default), informative messages printed.}
}
\value{
Data.frame of results.
}
\description{
Search for gene sequences available for a species from NCBI.
}
\details{
Removes predicted sequences so you don't have to remove them.
		Predicted sequences are those with accession numbers that have "XM_" or
		"XR_" prefixes.
}
\examples{
\dontrun{
# A single species
out <- ncbi_search(taxa="Umbra limi", seqrange = "1:2000")
# get list of genes available, removing non-unique
unique(out$gene_desc)
# does the string 'RAG1' exist in any of the gene names
out[grep("RAG1", out$gene_desc, ignore.case=TRUE),]

# A single species without records in NCBI
out <- ncbi_search(taxa="Sequoia wellingtonia", seqrange="1:2000", getrelated=TRUE)

# Many species, can run in parallel or not using plyr
species <- c("Salvelinus alpinus","Ictalurus nebulosus","Carassius auratus")
out2 <- ncbi_search(taxa=species, seqrange = "1:2000")
lapply(out2, head) # see heads of all
library("plyr")
out2df <- ldply(out2) # make data.frame of all
unique(out2df$gene_desc) # get list of genes available, removing non-unique
out2df[grep("60S ribosomal protein", out2df$gene_desc, ignore.case=TRUE),] # search across all
}
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}
\seealso{
\code{\link[taxize]{ncbi_getbyid}}, \code{\link[taxize]{ncbi_getbyname}}
}

