% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{gbif_name_usage}
\alias{gbif_name_usage}
\title{Lookup details for specific names in all taxonomies in GBIF.}
\usage{
gbif_name_usage(key = NULL, name = NULL, data = "all", language = NULL,
  datasetKey = NULL, uuid = NULL, sourceId = NULL, rank = NULL,
  shortname = NULL, start = NULL, limit = 20, ...)
}
\arguments{
\item{key}{(numeric) A GBIF key for a taxon}

\item{name}{(character) Filters by a case insensitive, canonical namestring,
e.g. 'Puma concolor'}

\item{data}{(character) Specify an option to select what data is returned. See Description
below.}

\item{language}{(character) Language, default is english}

\item{datasetKey}{(character) Filters by the dataset's key (a uuid)}

\item{uuid}{(character) A uuid for a dataset. Should give exact same results as datasetKey.}

\item{sourceId}{(numeric) Filters by the source identifier. Not used right now.}

\item{rank}{(character) Taxonomic rank. Filters by taxonomic rank as one of:
CLASS, CULTIVAR, CULTIVAR_GROUP, DOMAIN, FAMILY, FORM, GENUS, INFORMAL,
  INFRAGENERIC_NAME, INFRAORDER, INFRASPECIFIC_NAME, INFRASUBSPECIFIC_NAME,
KINGDOM, ORDER, PHYLUM, SECTION, SERIES, SPECIES, STRAIN, SUBCLASS, SUBFAMILY,
SUBFORM, SUBGENUS, SUBKINGDOM, SUBORDER, SUBPHYLUM, SUBSECTION, SUBSERIES,
SUBSPECIES, SUBTRIBE, SUBVARIETY, SUPERCLASS, SUPERFAMILY, SUPERORDER,
SUPERPHYLUM, SUPRAGENERIC_NAME, TRIBE, UNRANKED, VARIETY}

\item{shortname}{(character) A short name..need more info on this?}

\item{start}{Record number to start at}

\item{limit}{Number of records to return}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A list of length two. The first element is metadata. The second is
either a data.frame (verbose=FALSE, default) or a list (verbose=TRUE)
}
\description{
This is a taxize version of the same function in the \code{rgbif} package so as to not have to
import rgbif and thus require GDAL binary installation.
}
\references{
\url{http://www.gbif.org/developer/summary}
}

