% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankagg.R
\name{rankagg}
\alias{rankagg}
\title{Aggregate data by given taxonomic rank}
\usage{
rankagg(data = NULL, datacol = NULL, rank = NULL, fxn = "sum")
}
\arguments{
\item{data}{A data.frame. Column headers must have capitalized ranks (e.g.,
Genus, Tribe, etc.) (data.frame)}

\item{datacol}{The data column (character)}

\item{rank}{Taxonomic rank to aggregate by (character)}

\item{fxn}{Arithmetic function or vector or functions (character)}
}
\description{
Aggregate data by given taxonomic rank
}
\examples{
library("vegan")
data(dune.taxon, package='vegan')
dat <- dune.taxon
set.seed(1234)
dat$abundance <- round(rlnorm(n=nrow(dat),meanlog=5,sdlog=2),0)
rankagg(data=dat, datacol="abundance", rank="Genus")
rankagg(data=dat, "abundance", rank="Family")
rankagg(data=dat, "abundance", rank="Genus", fxn="mean")
rankagg(data=dat, "abundance", rank="Subclass")
rankagg(data=dat, "abundance", rank="Subclass", fxn="sd")
}

