% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxo_fuzzy_match.R
\name{taxo_fuzzy_match}
\alias{taxo_fuzzy_match}
\title{taxo_fuzzy_match}
\usage{
taxo_fuzzy_match(name, master, dist = 2)
}
\arguments{
\item{name}{Name to search}

\item{master}{List of names}

\item{dist}{Distance tolerance, Default: 2}
}
\value{
Matched name, string distance and original name. Null if not found.
}
\description{
Fuzzy matching with names
}
\details{
Fuzzy matching with names in the master list and return best match.
}
\examples{
\dontrun{
master <- data.frame("canonical" = c("Abrothrix longipilis",
                                    "Acodon hirtus",
                                    "Akodon longipilis apta",
                                    "Akodon longipilis castaneus",
                                    "Chroeomys jelskii",
                                    "Acodon jelskii pyrrhotis"),
                    stringsAsFactors = F)
 taxo_fuzzy_match("Acodon hirta",master)
}
}
