% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl.R
\name{env_tbls}
\alias{env_tbls}
\title{Convert all data frames in environment into tibbles}
\usage{
env_tbls(env = globalenv(), row_names = TRUE)
}
\arguments{
\item{env}{Name of environment from which data frames should be converted to tibbles.
Defaults to global environment.}

\item{row_names}{Logical indicating whether to create a row_names variable if non-auto
row names are found.}
}
\value{
The function will print messages when converting occurs and it will print a final
  completion message, but otherwise returns nothing.
}
\description{
Converts data frames found in a given environment into tibbles (tbl_df)
}
\examples{
## data with row names
d <- data.frame(x = rnorm(5), y = rnorm(5), row.names = letters[1:5])

## convert data frames in global environment to tibbles
env_tbls()

}
