% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/input.R
\name{parse.folder}
\alias{parse.file}
\alias{parse.file.list}
\alias{parse.folder}
\alias{parse.migec}
\alias{parse.mitcr}
\alias{parse.mitcrbc}
\title{Parse input table files with immune receptor repertoire data.}
\usage{
parse.file(.filename, .format = c('mitcr', 'mitcrbc', 'migec'), ...)

parse.file.list(.filenames, .format = c('mitcr', 'mitcrbc', 'migec'), .namelist = NA)

parse.folder(.folderpath, .format = c('mitcr', 'mitcrbc', 'migec'), ...)

parse.mitcr(.filename)

parse.mitcrbc(.filename)

parse.migec(.filename)
}
\arguments{
\item{.folderpath}{Path to the folder with text cloneset files.}

\item{.format}{String specifing input format of files. Parsers for MiTCR output and MiGEC output are available.}

\item{...}{Parameters passed to \code{parse.cloneset}.}

\item{.filename}{Path to the input file with cloneset data.}

\item{.filenames}{Vector or list with paths to files with cloneset data.}

\item{.namelist}{Either NA or character vector of length \code{.filenames} with names for output data frames.}
}
\value{
Data frame with immune receptor repertoire data. Each row in this data frame corresponds to a clonotype.
The data frame has following columns:

- "Barcode.count" - number of barcodes (events, UMIs);

- "Barcode.proportion" - proportion of barcodes (events, UMIs);

- "Read.count" - number of reads;

- "Read.proportion" - proportion of reads;

- "CDR3.nucleotide.sequence" - CDR3 nucleotide sequence;

- "CDR3.amino.acid.sequence" - CDR3 amino acid sequence;

- "V.segments" - names of aligned Variable gene segments;

- "J.segments" - names of aligned Joining gene segments;

- "D.segments" - names of aligned Diversity gene segments;

- "V.end" - last positions of aligned V gene segments (1-based);

- "J.start" - first positions of aligned J gene segments (1-based);

- "D5.end" - positions of D'5 end of aligned D gene segments (1-based);

- "D3.end" - positions of D'3 end of aligned D gene segments (1-based);

- "VD.insertions" - number of inserted nucleotides (N-nucleotides) at V-D junction (-1 for receptors with VJ recombination);

- "DJ.insertions" - number of inserted nucleotides (N-nucleotides) at D-J junction (-1 for receptors with VJ recombination);

- "Total.insertions" - total number of inserted nucleotides (number of N-nucleotides at V-J junction for receptors with VJ recombination).
}
\description{
Load the MITCR TCR data from the file with the given filename
to a data frame. For general parser see \code{\link{parse.cloneset}}.
}
\examples{
\dontrun{
# Parse file in "~/mitcr/immdata1.txt" as a MiTCR file.
immdata1 <- parse.file("~/mitcr/immdata1.txt", 'mitcr')
# Parse files "~/data/immdata1.txt" and "~/data/immdat2.txt" as MiGEC files.
immdata12 <- parse.file.list(c("~/data/immdata1.txt",
                             "~/data/immdata2.txt"), 'migec')
# Parse all files in "~/data/" as MiGEC files.
immdata <- parse.folder("~/data/", 'migec')
}
}
\seealso{
\link{parse.cloneset}
}

