% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_weights.R
\name{sp_weights}
\alias{sp_weights}
\title{Non parametric local heteroscedasticity weights}
\usage{
sp_weights(x, y, phi, preprocessed = FALSE, doPlot = FALSE, bw = c("nrd",
  "ucv", "SJ", "nrd0", "bcv"), kernel = c("gaussian", "epanechnikov",
  "rectangular", "triangular", "biweight", "tricube", "cosine", "optcosine"),
  exact = FALSE)
}
\arguments{
\item{x}{a numeric matrix of size \code{n x p} containing the model covariates from
\code{n} samples (design matrix).}

\item{y}{anumeric matrix of size \code{n x G} containing the raw RNAseq counts or
preprocessed expression from \code{n} samples for \code{G} genes.}

\item{phi}{a numeric design matrix of size \code{n x K} containing the K basis of time.}

\item{preprocessed}{a logical flag indicating wether the expression data have
already been preprocessed (e.g. log2 transformed). Default is \code{FALSE}, in
which case \code{y} is assumed to contain raw counts and is normalized into
log(counts) per million.}

\item{doPlot}{a logical flag indicating wether the mean-variance plot should be drawn.
Default is \code{FALSE}.}

\item{bw}{a character string indicating the smoothing bandwidth selection method to use. See
\code{\link[stats]{bandwidth}} for details. Possible values are \code{"ucv"}, \code{"SJ"},
\code{"bcv"}, \code{"nrd"} or \code{"nrd0"}. Default is \code{"nrd"}.}

\item{kernel}{a character string indicating which kernel should be used.
Possibilities are \code{"gaussian"}, \code{"epanechnikov"}, \code{"rectangular"},
\code{"triangular"}, \code{"biweight"}, \code{"tricube"}, \code{"cosine"},
\code{"optcosine"}. Default is \code{"gaussian"} (NB: \code{"tricube"} kernel
corresponds to the loess method).}

\item{exact}{a logical flag indicating wether the non-parametric weights accounting
for the mean-variance relationship should be computed exactly or extrapolated
from the interpolation of local regression of the mean against the
variance. Default is \code{FALSE}, which uses interporlation (faster).}
}
\value{
a vector of length \code{n} containing the computed precision weights.
}
\description{
Computes precision weights that account for heteroscedasticity in RNAseq count data
based on non-parametric local linear regression estimates.
}
\examples{
#rm(list=ls())
set.seed(123)

G <- 10000
n <- 12
p <- 2
y <- sapply(1:G, FUN=function(x){rnbinom(n=n, size=0.07, mu=200)})

x <- sapply(1:p, FUN=function(x){rnorm(n=n, mean=n, sd=1)})



}
\seealso{
\code{\link[stats]{bandwidth}} \code{\link{density}}
}

