#'tcgsaseq: a package to perform Time-course Gene Set Analysis and General Gene-Wise Analysis of RNA-seq data
#'
#'Analysis of RNA-seq data with variance component score
#'test accounting for data heteroscedasticity through precision weights.
#'
#'\tabular{ll}{
#'Package: \tab tcgsaseq\cr
#'Type: \tab Package\cr
#'Version: \tab 1.6.1\cr
#'Date: \tab 2017-08-04\cr
#'License:\tab \href{http://www.gnu.org/licenses/gpl-2.0.txt}{GPL-2}\cr
#'}
#'The two main functions of the \code{tcgsaseq} package are \code{\link{varseq}} and \code{\link{tcgsa_seq}}.
#'
#'
#'@author Boris P. Hejblum, Denis Agniel
#'--- Maintainer: Boris P. Hejblum
#'
#'@references Agniel D, Hejblum BP, Variance component score test for
#'time-course gene set analysis of longitudinal RNA-seq data, \emph{Biostatistics}, 2017.
#'\href{http://arxiv.org/abs/1605.02351v4}{arXiv:1605.02351} \url{https://doi.org/10.1093/biostatistics/kxx005}
#'
#'
#'@docType package
#'@name tcgsaseq
#'@importFrom GSA GSA.read.gmt
#'
NULL
