% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{eleveld_poppk}
\alias{eleveld_poppk}
\title{Eleveld population PK model}
\usage{
eleveld_poppk(df, PD = TRUE, rate = FALSE, rand = FALSE)
}
\arguments{
\item{df}{Data frame with variable names "AGE","PMA","WGT","HGT","M1F2","TECH",and "A1V2"}

\item{PD}{Logical. Should PD parameters be returned in addition to PK parameters.
Defaults to TRUE.}

\item{rate}{Logical. Should rate parameters be returned rather than clearance.
Defaults to FALSE}

\item{rand}{Logical. Should a vector of Monte Carlo samples be returned instead
of point estimates at patient covariate values. Defaults to FALSE.}
}
\value{
data.frame with covariate-based PK parameter estimates based on Eleveld propofol model.
}
\description{
Function takes a data frame of patient covariate values with variable names "AGE","PMA","WGT","HGT","M1F2","TECH",and "A1V2" and returns PK parameter values.
}
\examples{
dat <- data.frame(AGE  = c(20,40,65),
                  TBM  = c(50,70,90),
                  HGT  = c(150,170,200),
                  MALE = c(TRUE,FALSE,TRUE))

schnider_poppk(dat, rand = FALSE, rate = FALSE)
schnider_poppk(dat, rand = TRUE, rate = TRUE)
}
