% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_mods.R
\name{inv_emax}
\alias{inv_emax}
\title{Inverse Emax function}
\usage{
inv_emax(pdresp, pars)
}
\arguments{
\item{pdresp}{PD response values}

\item{pars}{Named vector of parameter values with names (c50,gamma,E0,Emx).}
}
\value{
Numeric vector of same length as pdresp.
}
\description{
Inverse Emax function to return effect-site concentrations required to reach target effect.
}
\examples{
pars_emax <- c(c50 = 1.5, gamma = 4, e0 = 100, emx = 100)
ce_seq <- seq(0,4,0.1)
all.equal(inv_emax(emax(ce_seq, pars_emax), pars_emax), ce_seq)
}
