% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ExpManifoldContour}
\alias{ExpManifoldContour}
\title{Builds and exports the mesh representing the desired isosurface}
\usage{
ExpManifoldContour(file_path, isovalue, verification, export_path)
}
\arguments{
\item{file_path}{A string: the path to the nhdr file}

\item{isovalue}{A number: the value corresponding to the desired isosurface}

\item{verification}{A boolean: determines whether the grid verification will be performed}

\item{export_path}{A string: the path to a directory to put the mesh generated, following by the file name.}
}
\value{
The file of the mesh in the ply format.
}
\description{
This function returns the file (ply format) of the mesh generated by the Marching Cubes 33 algorithm.
Optionally, the original dataset grid is preprocessed (subdivided in specifics points) to eliminate the configuration that
results in non-manifold edges.
}
\examples{
ExpManifoldContour(system.file("extdata", "f3.nhdr", package = "tcie"), 0.0, FALSE, "mesh.ply")
ExpManifoldContour(system.file("extdata", "f3.nhdr", package = "tcie"), 0.0, TRUE, "mesh.ply")
ExpManifoldContour(system.file("extdata", "f9.nhdr", package = "tcie"), 0.0, TRUE, "mesh.ply")
}
