% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.hourly}
\alias{f.hourly}
\title{Create an 'Hourly' Frequency}
\usage{
f.hourly(day, hour)
}
\arguments{
\item{day}{A 'Day-based' object of class \code{ldtf}, such as \code{Daily} or \code{Daily-In-Week}.}

\item{hour}{The index of the hour in the day, which should be between 1 and 24.}
}
\value{
An object of class \code{ldtf}. It is also a list with the following members:
\item{class}{Determines the class of this frequency.}
\item{day}{Determines the \code{day}.}
\item{hour}{Determines the \code{hour}.}
}
\description{
Use this function to create a frequency for time-series data that occurs hourly in a day or a subset of a week.
}
\details{
In order to use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format}: \code{"YYYYMMDD:#"} (where # represents the value of \code{hour})
\item \strong{Class Id}: \code{ho|...} (where '...' represents the 'class id' of \code{day})
}
}
\examples{

ho0 <- f.hourly(f.daily(c(2023,5,16)),4)

ho0_value_str <-  as.character(ho0) # this will be '20230516:4'.
ho0_class_str <- get.class.id(ho0)
#    this will be 'ho|d'. The second part (i.e., 'd')
#    shows that this frequency is defined in a 'Daily' frequency.

ho_new <- as.frequency("20231101:3", "ho|i:wed-sat")

# Don't make the following mistakes:
\donttest{
ho_invalid <- try(as.frequency("20231101:3", "ho|j:wed-sat"))
#  invalid format in day-based frequency
ho_invalid <- try(f.hourly(f.daily(c(2023,5,16)),25)) # invalid hour
}

}
