% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable.R
\name{as.character.ldtv}
\alias{as.character.ldtv}
\title{Convert a Variable to Character String}
\usage{
\method{as.character}{ldtv}(x, ...)
}
\arguments{
\item{x}{An object of class \code{ldtv}.}

\item{...}{Additional arguments.}
}
\value{
A character that represents the variable.
}
\description{
Use this function to convert a variable to a compact form.
}
\details{
The returned character will have just one line, with items separated by \code{tab} or \code{semi-colon}.
}
\examples{
# define the variable:
data <- c(1,2,3,2,3,4,5)
start_f <- f.monthly(2022,12)
fields <- list(c("key1","value1"), c("key2", "value2"))
v1 = variable(data,start_f, "V1", fields)

#string representation:
v1_str <- as.character(v1)

}
