% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-threaded-tdcm-stan.R
\name{create_threaded_stan_tdcm}
\alias{create_threaded_stan_tdcm}
\title{Creating Multi-Threaded TDCM Stan Code}
\usage{
create_threaded_stan_tdcm(q_matrix, profs)
}
\arguments{
\item{q_matrix}{A tibble containing the assessment Q-matrix.}

\item{profs}{A tibble of the possible attribute mastery profiles.}
}
\value{
`stan_code` A list containing the text for the Stan code blocks.
}
\description{
Automating the creation of multi-threaded Stan code for a TDCM.
}
\examples{
qmatrix = tibble::tibble(att_1 = c(1, 0, 1, 0, 1, 1), att_2 = c(0, 1, 0, 1, 1, 1))
possible_profiles = tibble::tibble(att_1 = c(0, 1, 0, 1), att_2 = c(0, 1, 0, 1))
create_threaded_stan_tdcm(q_matrix = qmatrix, profs = possible_profiles)
}
