% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{tquantile}
\alias{tquantile}
\alias{quantile.tdigest}
\title{Calculate sample quantiles from a t-Digest}
\usage{
tquantile(td, probs)

\method{quantile}{tdigest}(x, probs = seq(0, 1, 0.25), ...)
}
\arguments{
\item{td}{t-Digest object}

\item{probs}{numeric vector of probabilities with values in range 0:1}

\item{x}{numeric vector whose sample quantiles are wanted}

\item{...}{unused}
}
\value{
a \code{numeric} vector containing the requested quantile values
}
\description{
Calculate sample quantiles from a t-Digest
}
\examples{
set.seed(1492)
x <- sample(0:100, 1000000, replace = TRUE)
td <- tdigest(x, 1000)
tquantile(td, c(0, .01, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99, 1))
quantile(td)
}
\references{
\href{https://arxiv.org/abs/1902.04023}{Computing Extremely Accurate Quantiles Using t-Digests}
}
