% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_options.R
\name{add_options}
\alias{add_options}
\title{Pass objects and customization options to a shiny app}
\usage{
add_options(opts, dir, theme = "flatly", icon = NULL, img = NULL,
  git_user = NULL)
}
\arguments{
\item{opts}{A \code{list} of additional options or objects to pass to a shiny app}

\item{dir}{A \code{character} string indicating the path to the directory containing ui.R and server.R}

\item{theme}{A \code{character} string naming a Bootswatch color theme (used by \code{shinythemes::shinytheme})}

\item{icon}{A \code{character} string naming a fontAwesome icon to be placed in the footer of a navbarPage app}

\item{img}{A \code{character} string for the path/url of an image to be placed in the footer of a navbarPage app}

\item{git_user}{A \code{character} string for github username used in the branding link}
}
\value{
A list of shiny options set with \code{shinyOptions}
}
\description{
Provides a general method for passing arguments to shiny apps
    allowing for dynamic customization.
}
\details{
Shiny apps are not functions. Thus, customization options cannot be
    passed to a shiny app as simply as arguments are passed between functions.  Further,
    the manner in which objects are loaded prior to deploying an app differ if the app
    will be published as a stand-alone or embedded within an rmarkdown docmuent.
    Assigning objects as \code{shiny::shinyOptions} ensures that these values are 
    passed to a shiny app and can be deployed.
}
\seealso{
\code{\link{add_css}}

\code{\link{add_logo}}
}
