% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_standard_inputs.R
\name{validate_standard_inputs}
\alias{validate_standard_inputs}
\title{Validate standard input values for a teal module}
\usage{
validate_standard_inputs(
  adsl,
  adslvars = character(0),
  anl,
  anlvars = character(0),
  need_arm = TRUE,
  arm_var,
  ref_arm,
  comp_arm,
  min_n_levels_armvar = 1L,
  max_n_levels_armvar = 100L,
  min_nrow = 1
)
}
\arguments{
\item{adsl}{data.frame with subject-level data}

\item{adslvars}{required variables from \code{ADSL}}

\item{anl}{data.frame with analysis data}

\item{anlvars}{required variables from \code{ANL}}

\item{need_arm}{flag indicating whether grouping variable \code{arm_var}
is required or can be optionally \code{NULL}.}

\item{arm_var}{character with name of grouping variable, typically arm}

\item{ref_arm}{character with name of reference level in \code{arm_var}}

\item{comp_arm}{character with name for comparison level in \code{arm_var}}

\item{min_n_levels_armvar}{minimum number of levels in grouping variable \code{arm_var}.
Defaults to 1, \code{NULL} for no minimum.}

\item{max_n_levels_armvar}{maximum number of levels in grouping variable \code{arm_var}.
Use \code{NULL} for no maximum.}

\item{min_nrow}{minimum number of observations in \code{ADSL} and \code{ANL}}
}
\description{
Validates standard input.
}
\keyword{internal}
