% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_missing_data.R
\name{tm_missing_data}
\alias{tm_missing_data}
\title{\code{teal} module: Missing data analysis}
\usage{
tm_missing_data(
  label = "Missing data",
  plot_height = c(600, 400, 5000),
  plot_width = NULL,
  parent_dataname = "ADSL",
  ggtheme = c("classic", "gray", "bw", "linedraw", "light", "dark", "minimal", "void"),
  ggplot2_args = list(`Combinations Hist` = teal.widgets::ggplot2_args(labs =
    list(caption = NULL)), `Combinations Main` = teal.widgets::ggplot2_args(labs =
    list(title = NULL))),
  pre_output = NULL,
  post_output = NULL
)
}
\arguments{
\item{label}{(\code{character(1)}) Label shown in the navigation item for the module or module group.
For \code{modules()} defaults to \code{"root"}. See \code{Details}.}

\item{plot_height}{(\code{numeric}) optional, specifies the plot height as a three-element vector of
\code{value}, \code{min}, and \code{max} intended for use with a slider UI element.}

\item{plot_width}{(\code{numeric}) optional, specifies the plot width as a three-element vector of
\code{value}, \code{min}, and \code{max} for a slider encoding the plot width.}

\item{parent_dataname}{(\code{character(1)}) Specifies the parent dataset name. Default is \code{ADSL} for \code{CDISC} data.
If provided and exists, enables additional analysis "by subject". For non-\code{CDISC} data, this parameter can be
ignored.}

\item{ggtheme}{(\code{character}) optional, specifies the default \code{ggplot2} theme for plots. Defaults to \code{classic}.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional, object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}}
with settings for all the plots or named list of \code{ggplot2_args} objects for plot-specific settings.
The argument is merged with options variable \code{teal.ggplot2_args} and default module setup.

List names should match the following: \code{c("default", "Summary Obs", "Summary Patients", "Combinations Main", "Combinations Hist", "By Subject")}.

For more details see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{pre_output}{(\code{shiny.tag}) optional, text or UI element to be displayed before the module's output,
providing context or a title.
with text placed before the output to put the output into context. For example a title.}

\item{post_output}{(\code{shiny.tag}) optional, text or UI element to be displayed after the module's output,
adding context or further instructions. Elements like \code{shiny::helpText()} are useful.}
}
\value{
Object of class \code{teal_module} to be used in \code{teal} applications.
}
\description{
This module analyzes missing data in \code{data.frame}s to help users explore missing observations and
gain insights into the completeness of their data.
It is useful for clinical data analysis within the context of \code{CDISC} standards and
adaptable for general data analysis purposes.
}
\examples{
library(teal.widgets)

# module specification used in apps below
tm_missing_data_module <- tm_missing_data(
  ggplot2_args = list(
    "Combinations Hist" = ggplot2_args(
      labs = list(subtitle = "Plot produced by Missing Data Module", caption = NULL)
    ),
    "Combinations Main" = ggplot2_args(labs = list(title = NULL))
  )
)

# general example data
data <- teal_data()
data <- within(data, {
  require(nestcolor)

  add_nas <- function(x) {
    x[sample(seq_along(x), floor(length(x) * runif(1, .05, .17)))] <- NA
    x
  }

  iris <- iris
  mtcars <- mtcars

  iris[] <- lapply(iris, add_nas)
  mtcars[] <- lapply(mtcars, add_nas)
  mtcars[["cyl"]] <- as.factor(mtcars[["cyl"]])
  mtcars[["gear"]] <- as.factor(mtcars[["gear"]])
})
datanames(data) <- c("iris", "mtcars")

app <- init(
  data = data,
  modules = modules(tm_missing_data_module)
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

# CDISC example data
data <- teal_data()
data <- within(data, {
  require(nestcolor)
  ADSL <- rADSL
  ADRS <- rADRS
})
datanames(data) <- c("ADSL", "ADRS")
join_keys(data) <- default_cdisc_join_keys[datanames(data)]

app <- init(
  data = data,
  modules = modules(tm_missing_data_module)
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
